(function ($WC) {
    //Array.indexOf Polyfill
    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (searchElement, fromIndex) {
            var k; if (this === null) { throw new TypeError('"this" is null or not defined'); }
            var O = Object(this); var len = O.length >>> 0; if (len === 0) { return -1; }
            var n = +fromIndex || 0; if (Math.abs(n) === Infinity) { n = 0; }
            if (n >= len) { return -1; } k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);
            while (k < len) { if (k in O && O[k] === searchElement) { return k; } k++; }
            return -1;
        };
    }

    // Should we redirect the user to the mobile theme?
    if (document.location.href.toLowerCase().indexOf("theme=") == -1) {
      var ua = navigator.userAgent.toLowerCase();
      if (ua.indexOf("iphone") !== -1 || ua.indexOf("android") !== -1 || ua.indexOf("windows ce") !== -1 || ua.indexOf("playstation portable") !== -1 || ua.indexOf("blackberry") !== -1 || ua.indexOf("ipad") !== -1 || ua.indexOf("iemobile") !== -1 || ua.indexOf("playbook") !== -1) {
        var d = document.documentElement.style;
        if ((('flexWrap' in d) || ('WebkitFlexWrap' in d) || ('msFlexWrap' in d)) && window.sessionStorage) {
          localStorage.setItem("theme", "Mobile");
          document.location.href = "/webmail/index.html";
          return;
        }
        else {
          if (localStorage) {
            localStorage.setItem("theme", "Lite");
          }
          document.location.href = "/WorldClient.dll?View=Logon&Theme=Lite";
          return;
        }
      }
    }

    $WC.languages.pop();

    //Switch from the browser language code to the $WC language code
    var langSwitch = { "en-US": "en", "en-GB": "uk", "en-AU": "uk",
        "en-NZ": "uk", "en-CA": "uk", "en-ZA": "uk", "fr-FR": "fr",
        "fr-CA": "fc", "fr-CH": "fr", "zh-CN": "zh", "zh-TW": "tw",
        "de-AT": "de", "de-DE": "de", "de-LI": "de", "de-CH": "de",
        "pt-BR": "pt", "pt-PT": "pt", "it-IT": "it", "it-CH": "it",
        "nb": "no", "es-419": "es", "sh": "sr"
    },

    language = localStorage.getItem("lang") || (navigator.userLanguage ? navigator.userLanguage : navigator.language);

    if (typeof language !== 'undefined') {
        language = langSwitch[language] || language;
        if ($WC.lang !== language && $WC.languages.indexOf(language) !== -1) {
            $WC.lang = language;
        }
    }

	var showFocus = function (obj) {
		if (!document.getElementById) {
			return;
        }
		obj.style.border = "1px solid #000";
	};

	var showBlur = function (obj) {
		if (!document.getElementById) {
			return;
        }
		obj.style.border = "1px solid #999";
	};

	var updateTranslationStrings = function (strs) {
        if (strs.assistance) {
            $('#assistance').text(strs.assistance);
        }
        if (strs.emailAddress) {
            $('#emailAddressTranslationString').text(strs.emailAddress + ': ');
        }
        if (strs.password) {
            $('#passwordTranslationString').text(strs.password + ': ');
        }
        if (strs.logon) {
            $('#Logon').val(strs.logon);
        }
        if (strs.createAccount) {
            $('#createAccountTranslationString').val(strs.createAccount);
        }
        if (strs.language) {
            $('#languageTranslationString').text(strs.language + ': ');
        }
        if (strs.theme) {
            $('#themeTranslationString').text(strs.theme + ': ');
        }
        if (strs.help) {
            $('#helpTranslation').text(strs.help);
        }
        if (strs.forgotPassword) {
            $("#passwordRecovery").text(strs.forgotPassword);
        }
        if (strs.whatsNew) {
            $("#whatsNewTranslation").text(strs.whatsNew);
        }
        if (strs.updateAvailable) {
            $("#updateAvailable").text(strs.updateAvailable);
        }
        if (strs.termsOfUseCheck) {
            $("#termsOfUseCheck").text(strs.termsOfUseCheck);
        }
        if (strs.termsOfUse) {
            $("#termsOfUse").text(strs.termsOfUse);
        }
        if (strs.rememberMeTitle) {
            $("#RememberMe").attr("title", strs.rememberMeTitle);
        }
        if (strs.rememberMeOption) {
            $("#rememberMeOption").text(strs.rememberMeOption);
        }
    },
    
    init = function () {
        var form = document.forms[0];
	    $("#Lang").on("change", function () {
	        $.ajax({
	            "url": $WC.link + "?&TRANSLATION=1&THEME=" + $WC.theme + "&RETURNJAVASCRIPT=1&Lang=" + ($("#Lang").val() || $WC.lang),
	            "dataType": "json"
	        }).done(function (strs) {
	            updateTranslationStrings(strs);
	        });
	    });

	    $("#passwordRecovery").on("click", function () {
	        document.location.href = $WC.link + '?View=PasswordRecovery&Lang=' + ($("#Lang").val() || $WC.lang) + '&User=' + encodeURIComponent(punycode.encodeEmail($("#User").val()));
	    });

		try {
			if (self.parent.frames.length !== 0) {
				self.parent.location=document.location;
			}
			
			var objs = [form.User, form.Password, form.Logon, form.NewAccount,form.Lang, form.Theme];
			var i = objs.length;
			var maxWidth = 0;
			while (i--) {
				if (objs[i] && parseInt(objs[i].offsetWidth,10) > maxWidth) {
					maxWidth = parseInt(objs[i].offsetWidth,10);
				}
			}
			i = objs.length;
			while (i--) {
				if (objs[i]) {
					objs[i].style.width = maxWidth + 'px';
			    }
			}
	        if ($WC.theme && $("#Theme").length > 0) {
	        	SetOption('Theme', $WC.theme);
	        }
	        if ($WC.lang && $("#Lang").length > 0) {
	        	SetOption('Lang', $WC.lang);
                $("#Lang").change();
	        }
	        if (form.User.value.length > 0) {
                if ("punycode" in window) {
                    form.User.value = punycode.decodeEmail(form.User.value);
                }
				form.Password.focus();
			}
			else {
				form.User.focus();
			}
		}
		catch(exception){}

		$("#User, #Password").on("focus", function (e){
			showFocus(this);
		});

		$("#User, #Password").on("blur", function (e) {
			showBlur(this);
		});

        if (localStorage) {
            var savedTheme = localStorage.getItem("theme"), savedLang = localStorage.getItem("lang");
            if (savedTheme !== null && /^[A-Za-z0-9]+$/.test(savedTheme)) {
                $("#Theme").val(savedTheme).change();
            }
            else {
                localStorage.removeItem("theme");
            }
        }

        form.onsubmit = function () {
            document.getElementById('Logon').disabled = true;

            if ("punycode" in window) {
                form.User.value = punycode.encodeEmail(form.User.value);
            }

            if (form.User.value !== GetCookie("User")) {
                SetCookie("User", form.User.value);
            }

            if (localStorage) {
                if ($("#Theme").length > 0 && savedTheme !== $("#Theme").val()) {
                    localStorage.setItem("theme", $("#Theme").val());
                    SetCookie("Theme", $("#Theme").val());
                }
                if ($("#Lang").length > 0 && savedLang !== $("#Lang").val()) {
                    localStorage.setItem("lang", $("#Lang").val());
                    SetCookie("Lang", $("#Lang").val());

                }
                if (form.RememberMe && form.RememberMe.checked) {
                    localStorage.setItem("wc_remembered", form.User.value);
                }
                
            }
        };
	};

	$(document).ready(function () {
		init();
	});
}($WC));