
top.document.title = "Sign In - CenturyLink Webmail";
var g_iTRP = 0;
var g_iResendCodeCounter = 60;

//:::::::
//:::::::
function fnShowSigninF() {

}

//::::::
//::::::
function fnUpdateErrMsg(sMessage, sObj) {
	$("#" + sObj).html(sMessage);

}

//:::::::
//:::::::	
function fnSignin(sMode) {

	//#sign-in-email ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	var g_sFSignin_email;
	var g_sFSignin_password;

	var g_bFormValidS1 = true;

	g_sFSignin_email = $('#sign-in-email').val().trim();
	if (g_sFSignin_email.length == 0) {
		fnUpdateErrMsg("Enter an email", 'errmsg_signin_email');
		$('#errmsg_signin_email').css("visibility", "visible");
		$('#sign-in-email').addClass('border-red');
		g_bFormValidS1 = false;
	} else if (g_sFSignin_email.length < 2) {
		fnUpdateErrMsg("Not a valid email", 'errmsg_signin_email');
		$('#errmsg_signin_email').css("visibility", "visible");
		$('#sign-in-email').addClass('border-red');
		g_bFormValidS1 = false;
	} else {

		//:::
		if (!g_sFSignin_email.match(/^([A-Za-z0-9_\-\.'])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/)) {
			fnUpdateErrMsg("Not a valid email", 'errmsg_signin_email');
			$('#errmsg_signin_email').css("visibility", "visible");
			$('#sign-in-email').addClass('border-red');
			g_bFormValidS1 = false;
		}
		else if (g_sFSignin_email.match(/^([A-Za-z0-9_\-\.'])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/)) {
			$('#errmsg_signin_email').css("visibility", "Hidden");
			$('#sign-in-email').removeClass('border-red');
		}
		//:::
	}
	//

	//#signin_password
	g_sFSignin_password = $('#signin_password').val();
	if (!g_sFSignin_password.length > 0) {
		fnUpdateErrMsg("Enter a password", 'errmsg_signin_password');
		$('#errmsg_signin_password').css("visibility", "visible");
		$('#signin_password').addClass('border-red');
		g_bFormValidS1 = false;
	}
	else {
		$('#errmsg_signin_password').css("visibility", "Hidden");
		$('#signin_password').removeClass('border-red');
	}

	if (g_bFormValidS1 == false) {
		return false;
	}

	//#sign-in-email ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


	fnDisableButton('signup_btn', true);
	$(".loadingimg").css("visibility", "visible");

	var sPageUsername = g_sFSignin_email;
	var sPagePassword = g_sFSignin_password;
	var sPageDomain = '';
	var sPageRememberMe;

	var arrLogin = sPageUsername.split("@");
	sPageUsername = arrLogin[0];

	if (arrLogin.length == 2)
		sPageDomain = arrLogin[1];


	if (document.getElementById('RememberMe').checked)
		sPageRememberMe = 'on';
	else
		sPageRememberMe = '';


	if (typeof top.mDOMReady === "undefined") {
		fnSigninAPI(sPageUsername, sPagePassword, sPageDomain, sPageRememberMe);
	} else {
		top.fnSignin(sPageUsername, sPagePassword, sPageDomain, sPageRememberMe);
	}

	try {
		var oForm = document.getElementById('form');
		window.external.AutoCompleteSaveForm(oForm);
	}
	catch (err) {
		//Handle errors here
	}

	return false;

}

//:::::::
//:::::::
function fnSigninAPI(sPageUsername, sPagePassword, sPageDomain, sPageRememberMe) {
	$("#errmsg_api").css("visibility", "hidden");

	var sURL = 'api=signin&username=' + encodeURI(sPageUsername) + '&password=' + encodeURIComponent(sPagePassword) + '&domaincode=' + encodeURIComponent(m_sDomaincode) + '&RememberMe=' + sPageRememberMe + '&domain=' + sPageDomain;

	//:::: For timezone
	var ctime = g_sCtime;
	var tz = null;
	if (new Date()) {
		var mydate = new Date();
		tz = ((mydate.getTimezoneOffset() / 60) * -1);
		if ((tz != null) && (tz > -15) && (tz < 15))
			sURL += "&tz=" + tz;

		var myyear = mydate.getYear();
		if (myyear < 200) myyear = myyear + 1900;
		ctime = (mydate.getMonth() + 1) + "/" + mydate.getDate() + "/" + myyear + " " + mydate.getHours() + ":" + mydate.getMinutes() + ":" + mydate.getSeconds();
	}
	if (ctime.length > 0)
		sURL += "&ctime=" + escape(ctime);
	//////

	/*
	*/

	//API call
	$.ajax({
		type: "POST",
		url: '../../app/pageapi.asp',
		data: sURL,
		success: function (data) {

			var objSAM = eval("(" + data + ")");
			if (objSAM.msg == "0") {
				m_sUsername = objSAM.username.toLowerCase();
				m_sDomain = objSAM.domain.toLowerCase();
				m_bPublicContacts = (objSAM.bpubliccontacts == 'True');
				m_bSigendin = true;
				sName = objSAM.FirstName + ' ' + objSAM.LastName;
                if ( (objSAM.security_feature == 'True') && (g_bMobile == false)) {
                    fnShowSecurityFeature();
                }
                else {
                    if (g_bMobile)
					{
						//::
						fnLogLACT(601);
						//
						setTimeout(function() {

							if (s_SwitchMobile2 == 'true')
								location = '/../../mw/';	
							else
								location = '/../../mobileweb/';

							
						}, 400);
						
					}
                    else {
                        var pathname = location.pathname;
                        pathname = pathname.replace(new RegExp("[\/]+$"), "");
                        switch (pathname) {
                            case '/ndrive':
                                location = '/../../ndrive/';
                                break;
                            case '/ncal':
                                location = '/../../ncalendar/';
                                break;
                            case '/ncontacts':
                                location = '/../../ncontacts/';
                                break;
                            default:
                                location = '/../../app/';
                                break;
                        }
                    }
                }
			}
			else
			{
				//::
				fnLogLACT(602);
				sLoginfailed();
			}

	},
		fail: function (xhr, textStatus, errorThrown) {
			//alert('request failed');
		}
		});


}


//:::::::
//:::::::
function fnLogLACT(iType) {
	//API call
	$.ajax({
		
		type: "GET",
		url: '../../app/loglact.asp?logtype=' + iType,
		data: "",
		success: function(data) {
			//alert('response:' + data)
		  }
	  });
}

//::::::
//::::::
function fnShowSecurityFeature() {
    $("#SecurityFeatureModal").modal({
        backdrop: 'static',
        keyboard: false
    });
}

function fnSecurityFeatureModalNow()
{
    location = '/../../v1/recover/options.asp?autologin=true';
}

function fnSecurityFeatureModalLater() {
    //API call
    $.ajax({
        type: "POST",
        url: '/../../v1/recover/optionsapi.asp',
        data: 'api=reset',
        success: function (data) {
            if (g_bMobile)
                location = '/../../mobileweb/home.asp';
            else {
                var pathname = location.pathname;
                pathname = pathname.replace(new RegExp("[\/]+$"), "");
                switch (pathname) {
                    case '/ndrive':
                        location = '/../../ndrive/';
                        break;
                    case '/ncal':
                        location = '/../../ncalendar/';
                        break;
                    case '/ncontacts':
                        location = '/../../ncontacts/';
                        break;
                    default:
                        location = '/../../app/';
                        break;
                }
            }
        },
        fail: function (xhr, textStatus, errorThrown) {
            location = '/../../app/';
        }
    });
}

//::::::
//::::::
function fnResendTimerfnSigninTimer() {
	fnDisableButton('signup_btn', true);
	fnUpdateErrMsg('Invalid username or password.&nbsp;&nbsp;Try again in ' + g_iResendCodeCounter + ' seconds', 'errmsg_api');

	$('#errmsg_api').html();
	$("#errmsg_api").css("visibility", "visible");

	var interval = setInterval(function () {
		g_iResendCodeCounter--;
		// Display 'counter' wherever you want to display it.
		if (g_iResendCodeCounter <= 0) {
			clearInterval(interval);
			fnUpdateErrMsg('', 'errmsg_api');
			$("#errmsg_api").css("visibility", "hidden");
			fnDisableButton('signup_btn', false);
			g_iResendCodeCounter = (60) * (g_iTRP - 2);

			return;
		} else {
			if (g_iResendCodeCounter > 1)
				fnUpdateErrMsg('Invalid username or password.  &nbsp;&nbsp;Try again in ' + g_iResendCodeCounter + ' seconds', 'errmsg_api');
		}
	}, 1000);
}

//:::::::
//:::::::
function sLoginfailed() {
	g_iTRP += 1;

	$(".loadingimg").css("visibility", "hidden");

	//::::::
	if (g_iTRP == 20) {
		$("#g-recaptcha").css("display", "");
		fnDisableButton('signup_btn', true);
		fnUpdateErrMsg('You must verify that you are a human', 'errmsg_api');
		$("#errmsg_api").css("visibility", "visible");
		return false;
	}

	//::::::
	if (g_iTRP > 20) {
		fnResendTimerfnSigninTimer();
		return false;
	}

	fnUpdateErrMsg('Invalid username or password.&nbsp;&nbsp;Try again', 'errmsg_api');
	$("#errmsg_api").css("visibility", "visible");

	fnDisableButton('signup_btn', false);

}

//::::::
//::::::
function fnDisableButton(f_sID, f_bDisable) {
	if (f_bDisable) {
		$('#' + f_sID).prop('disabled', true);
		$('#' + f_sID).addClass('btndisabled');

	}
	else {
		$('#' + f_sID).prop('disabled', false);
		$('#' + f_sID).removeClass('btndisabled');
	}
}


//:::::::
//:::::::
function fnLoginSuccess() {
	top.document.title = "Mail - CenturyLink Webmail";
}

//:::::::
//:::::::
function fnLoginNoSession() {
	//$('#sign-in-email').val('')
	document.getElementById('RememberMe').checked = false;
}


//:::::::
//:::::::	
function fnSigninKeyDown(ObjTXT, evt) {
	evt = (evt) ? evt : event;
	var charCode = (evt.charCode) ? evt.charCode :
		((evt.which) ? evt.which : evt.keyCode);

	//enter
	if (charCode == 13) {
		if (!$('#signup_btn').hasClass('btndisabled'))
			fnSignin('m');
	}
}


//:::::::
//:::::::
function submitViaEnter(evt) {
	evt = (evt) ? evt : event;
	var charCode = (evt.charCode) ? evt.charCode :
		((evt.which) ? evt.which : evt.keyCode);
	if (charCode == 13) {
		fnSignin('m');
	}
}

//:::::::
//:::::::
function fnFeedback() {
	$("#FeedBackmodal").modal();
}

function UpdateInboxAlert(sText) {
	alert(sText)
}
	

//::::::
jQuery('document').ready(function () {

	$('#FeedBackmodal').on('hidden.bs.modal', function () {
		$("#FeedbackModalBody").css("height", "230px");
		var iframe = document.getElementById('ifrFeedBack');
		iframe.src = iframe.src;
	})

});

//::::::
//::::::
function fnResizeFeedBack() {
	var iFrameHeight = $('#ifrFeedBack').contents().find("html").height();
	var iWindowHEight = $(window).height();
	var iNewFrameHeight = iWindowHEight - 115;

	$('#FeedbackModalBody').animate({ height: iNewFrameHeight }, 400);
}

//::::::
//::::::
function fnRecaptchaCallback() {
	$("#g-recaptcha").css("display", "none");
	grecaptcha.reset();

	$("#errmsg_api").css("visibility", "hidden");
	fnDisableButton('signup_btn', false);
}