

	// [2006-07-06] 파이어폭스에서 비밀번호란에 한글을 입력할 수 있는 문제를 보완.
	// ex)  onKeyPress="JavaScript:return password_not_kor(this);"
	function password_not_kor(obj)
	{
		rexp = /[ㄱ-ㅎ|ㅏ-ㅣ|가-힝]/;
		if (rexp.test(obj.value))
		{
			alert("비밀번호에는 한글을 사용하실 수 없습니다.\n\n[한/영]전환키를 눌러 '영문모드'에서 입력해주시기 바랍니다.");
			obj.value = '';
			obj.focus();
			return false;
		}
		return true;
	}


	function list_click(obj, classNew, classOrig)
	{
		if (obj.className!=classNew) 
		{ 
			obj.className=classNew;
		} else 
		{ 
			obj.className=classOrig;
		}
	}

	function checkedCheckBoxClick(f, objName)
	{
		var cnt = countCheckBox(f, objName);
		var element = f.elements;

		for (var eCount = 0; eCount < element.length; eCount++)
		{
			if (element[eCount].type == "checkbox" && element[eCount].name == objName)
			{				
				if (cnt == 0)
				{
					if (element[eCount].checked == true)
					{
						element[eCount].click();
						element[eCount].click();
					} else
					{
						element[eCount].click();
						element[eCount].checked = true;
					}
				} else
				{
					if (element[eCount].checked == false)
					{
						element[eCount].click();
						element[eCount].click();
					} else
					{
						element[eCount].click();
						element[eCount].checked = false;
					}
				}
			}
		}
	}

	// [2003-10-09] 폼내에 다른 체크박스가 존재할 경우의 에러해결.

	function countCheckBox(f, objName)
	{
		var element = f.elements;
		var cnt = 0;

		for (var eCount = 0; eCount < element.length; eCount++)
		{
			if (element[eCount].type == "checkbox" && element[eCount].name == objName)
			{
				if(element[eCount].checked)
				{
					cnt ++;
				}
			}
		}

		return cnt;
	}


	function checkedCheckBox(f, objName)
	{
		var cnt = countCheckBox(f, objName);
		var element = f.elements;

		for (var eCount = 0; eCount < element.length; eCount++)
		{
			if (element[eCount].type == "checkbox" && element[eCount].name == objName)
			{				
				if (cnt == 0)
				{
					element[eCount].checked = true;
				} else
				{
					element[eCount].checked = false;
				}
			}
		}
	}



/*
	[2002-06-03]
	이메일주소 검사
	function isEmail(str)
	{
		// are regular expressions supported?
		var supported = 0;
		if (window.RegExp)
		{
				var tempStr = "a";
				var tempReg = new RegExp(tempStr);
				if (tempReg.test(tempStr)) supported = 1;
		}

		if (!supported)
			return (str.indexOf(".") > 2) && (str.indexOf("@") > 0);
		var r1 = new RegExp("(@.*@)|(\\.\\.)|(@\\.)|(^\\.)");
		var r2 = new RegExp("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$");
		return (!r1.test(str) && r2.test(str));
	}
*/

	// [2004-10-04]이메일 주소 체크
	function isEmail(str)
	{
		// are regular expressions supported?
		var supported = 0;
		if (window.RegExp)
		{
				var tempStr = "a";
				var tempReg = new RegExp(tempStr);
				if (tempReg.test(tempStr)) supported = 1;
		}

		if (!supported)
			return (str.indexOf(".") > 2) && (str.indexOf("@") > 0);
		var r1 = new RegExp("(@.*@)|(\\.\\.)|(@\\.)|(^\\.)");

		// [2004-11-29] '관리자<user@mail.com>'형태일때의 예외처리 추가.
		// [2007-06-05] "test2@passkorea.net" <test2@passkorea.net> 형태일때의 예외처리 추가.
		str_b = str.indexOf("<");
		str_e = str.indexOf(">");
		if ((str_b > 0)&&(str_e > 0))
		{
			str_addr = str.substring(str_b + 1, str_e);
			// [2007-11-13] info 도메인을 잘못된 주소로 파악하는 문제 수정.
			//var r2 = new RegExp(".+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)");
			var r2 = new RegExp(".+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]+|[0-9]{1,3})(\\]?)");
		} else
		{
			str_addr = str;
			//var r2 = new RegExp("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$");
			var r2 = new RegExp("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]+|[0-9]{1,3})(\\]?)$");
		}

		return (!r1.test(str_addr) && r2.test(str));
	}

/*
	[2002-06-03]
	폼에서 이메일주소 검사
*/
	function form_chk_email(obj, objName)
	{
		var result;
		var msg;

		result = trim(obj.value);
		if (result != "")
		{
			if (isEmail(result) == false)
			{
				alert(objName + " 주소가 잘못되었습니다.");
				obj.focus();
				if (obj.type == "text") obj.select();
				return(false);
			}
		}
	}


/*
	[2002-04-15]
	정수여부 검사 (object, string, int, int)

	[2002-06-11] 널값일때는 체크하지 않도록함.

	[2002-06-20] 음수도 체크함.

*/

	function form_chk_int(obj, objName, objValueMin, objValueMax)
	{
		result = trim(obj.value);
		if (result != "")
		{
			for(i = 0 ; i < obj.value.length ; i++)
			{
				if( (obj.value.charAt(i) < '0' || obj.value.charAt(i) > '9') && (obj.value.charAt(i) != '-') )
				{
					alert(objName + "은(는) 정수로만 입력하세요.");
					obj.focus();
					obj.select();
					return(false);
				}
			}

			if ( ( ((obj.value * 10) / 10) < ((objValueMin * 10) / 10) ) || ( ((obj.value * 10) / 10) > ((objValueMax * 10) / 10) ) )
			{
				alert(objName + "은(는) " + objValueMin + "에서 " + objValueMax + "사이의 정수로만 입력하세요.");
				obj.focus();
				obj.select();
				return(false);
			}
		}
	}

	/* ex

		var f = document.register;

		// 정수여부 검사
		if (form_chk_value(f.b_ad_total, "홍보비용") == false) return;
		if (form_chk_number(f.b_ad_total, "홍보비용") == false) return;
		if (form_chk_int(f.b_ad_total, "홍보비용", 1, 9999999999) == false) return;

	*/



// 체크박스의 선택여부 알아내기 (document.form, 'chkNo[]', '게시물')
	function form_chk_isChecked(form, cbObjName, cbObjText)
	{
		for(i=0; i < form.elements.length ; i++){
			if ( (form.elements[i].name == cbObjName) && (form.elements[i].checked == true) )
			{
				return(true);		// 선택된 결과가 있을때
				break;
			}
		}
		alert("선택된 " + cbObjText + "가(이) 없습니다.\n\n먼저 선택하여 주십시오");
		return(false);		// 선택된 결과가 없을때
	}

	/* ex)
				bCheck = form_chk_isChecked(form, "chkNo[]", "게시물");
				if ( bCheck == false ) return;
	*/


// 영어와숫자만 입력되었는가 검사함 (document.form.username, '관리자ID')
	// 하이폰(-), 언더바(_) 입력가능
	// [2006-06-14] 마침표(.) 입력가능.
	function form_chk_onlyEngNum(chkObj, chkObjText)
	{

		for(i = 0 ; i < chkObj.value.length ; i++)
		{
			if((chkObj.value.charAt(i) < "A" || chkObj.value.charAt(i) > "Z" ) && (chkObj.value.charAt(i) < "a" || chkObj.value.charAt(i) > "z" ) && ( chkObj.value.charAt(i) < '0' || chkObj.value.charAt(i) > '9') && ( chkObj.value.charAt(i) != '-' && chkObj.value.charAt(i) != '_' && chkObj.value.charAt(i) != '.') )
			{
				alert(chkObjText + "은(는) 영문와 숫자로만 입력하세요.");
				chkObj.focus();
				return(false);
			}
		}
	}

	/* ex)
				bCheck = form_chk_onlyEngNum(form.lid, "지역ID");
				if ( bCheck == false ) return;
	*/


// 폼내의 특정 element찾기
	function form_findElement(form, element)		// 찾을 폼, 찾을 객체이름(obj.name or 'lc_cd[]')
	{
		for(i=0; i < form.elements.length ; i++){
			if(form.elements[i].name == element){
				element = form.elements[i];
				return(element);
			}
		}
	}

	/* ex)

			// 배열로 선언된 객체를 제어하기
			var selectObj = form_findElement(document.form, 'lc_cd[]');		// selectObj => document.form.elements[?]

	*/


// 입력여부 검사 (document.form[0].title, 제목)
	function form_chk_value(obj, objName)
	{
		var result;
		var msg;

		result = trim(obj.value);
		if (result == "")
		{
			if ( (obj.type == "text") || (obj.type == "textarea") || (obj.type == "password") )
			{
				msg = "입력";
			}else
			{
				msg = "선택";
			}
			alert( objName + "을(를) " + msg + "하세요.");
			obj.focus();

			if (obj.type == "text") obj.select();

			return(false);
		}
	}

	/* ex)
				bCheck = form_chk_value(form.lid, "지역ID");
				if ( bCheck == false ) return;
	*/


// 최소길이 검사 (document.form[0].title, 제목)
	function form_chk_minLen(obj, objName, minLen)
	{
		var result;
		var msg;

		result = trim(obj.value);
		if (result.length < minLen)
		{
			alert( objName + "은(는) " + minLen + "자이상 입력하세요.");
			obj.focus();
			obj.select();

			return(false);
		}
	}

	/* ex)
				bCheck = form_chk_minLen(form.lid, "지역ID", 4);
				if ( bCheck == false ) return;
	*/


// 숫자만 입력하도록 검사 (document.form[0].money, 가격)
	function form_chk_number(obj, objName)
	{
		var result;

		result = trim(obj.value);
		if (isNaN(result))
		{
			alert( objName + "은(는) 숫자로만 입력하세요.");
			obj.focus();
			if (obj.type == "text") obj.select();

			return(false);
		}
	}

	/* ex)
				bCheck = form_chk_number(form.money, "가격");
				if ( bCheck == false ) return;
	*/



// 날짜여부 검사 (dateObject = document.form[0].date1)(msg = 객체명)
	function form_chk_date(dateObject, msg)
	{
		var date = dateObject.value;
		var s_date = date.split("-");
		var yyyy = (s_date[0]*10)/10;		// parseInt()의 경우 "08", "09"일때 0으로 잘못 변경되므로 연산을 이용함.
		var mm = (s_date[1]*10)/10;
		var dd = (s_date[2]*10)/10;
		var chk_day;
		var result;

		if ( date != "" )		// 입력값이 존재할때만 검사함
		{
			if ( (date.length >= 8) && (date.length <= 10) )		// [길이] 2001-1-1 ~ 2001-12-12
			{
				if ( s_date.length == 3 )		// [형식] xxxx-xx-xx
				{
					if ( (yyyy >= 1899) && (yyyy <= 2200) )		// [년도] 1899년 ~ 2200년
					{
						if ( (mm >= 1) && (mm <= 12) )		// [월] 1월 ~ 12월
						{
							switch (mm) {		// [달별날수] 1월 - 31, 4월 - 30 ...
								case 2:
									chk_day = (!(yyyy % 4) && (yyyy % 100) || !(yyyy % 400)) ? 29 : 28;		// 윤년구분
									break;
								case 4: case 6: case 9: case 11:
									chk_day = 30;
									break;
								default :
									chk_day = 31;
									break;
							}
							//alert(chk_day + " / " + dd + " / " + s_date[2]);
							if ( (dd >= 1) && (dd <= chk_day) )			// [일] 1일 ~ 달별날수
							{
								result = true;
							}
						}
					}
				}
			}
			if (result != true)
			{
				alert(msg + "의 날짜형식이 잘못되었거나 올바른 날짜가 아닙니다.\n\n[2001-01-01]형식으로 입력하여 주십시오.");
				dateObject.focus();
				dateObject.select();
				return(false);
			}
		}
	}

	/* ex
			// 날짜여부 검사
			bCheck = form_chk_date(form.c_buydate, "차량등록일");
			if ( bCheck == false ) return;
	*/


// [2008-01-19] 결혼기념일 날짜 검사
	function form_chk_date_value(dateObject, date, msg)
	{
		//var date = dateObject.value;
		var s_date = date.split("-");
		var yyyy = (s_date[0]*10)/10;		// parseInt()의 경우 "08", "09"일때 0으로 잘못 변경되므로 연산을 이용함.
		var mm = (s_date[1]*10)/10;
		var dd = (s_date[2]*10)/10;
		var chk_day;
		var result;

		if ( date != "" && date != "--" )		// 입력값이 존재할때만 검사함
		{
			if ( (date.length >= 8) && (date.length <= 10) )		// [길이] 2001-1-1 ~ 2001-12-12
			{
				if ( s_date.length == 3 )		// [형식] xxxx-xx-xx
				{
					if ( (yyyy >= 1899) && (yyyy <= 2200) )		// [년도] 1899년 ~ 2200년
					{
						if ( (mm >= 1) && (mm <= 12) )		// [월] 1월 ~ 12월
						{
							switch (mm) {		// [달별날수] 1월 - 31, 4월 - 30 ...
								case 2:
									chk_day = (!(yyyy % 4) && (yyyy % 100) || !(yyyy % 400)) ? 29 : 28;		// 윤년구분
									break;
								case 4: case 6: case 9: case 11:
									chk_day = 30;
									break;
								default :
									chk_day = 31;
									break;
							}
							//alert(chk_day + " / " + dd + " / " + s_date[2]);
							if ( (dd >= 1) && (dd <= chk_day) )			// [일] 1일 ~ 달별날수
							{
								result = true;
							}
						}
					}
				}
			}
			if (result != true)
			{
				alert(msg + "의 날짜형식이 잘못되었거나 올바른 날짜가 아닙니다.\n\n[2001-01-01]형식으로 입력하여 주십시오.");
				dateObject.focus();
				dateObject.select();
				return(false);
			}
		}
	}


// 날짜여부 검사 (dateObject = document.form[0].date1)(msg = 객체명)
	function form_chk_date_ym(dateObject, msg)
	{
		var date = dateObject.value;
		var s_date = date.split("-");
		var yyyy = (s_date[0]*10)/10;		// parseInt()의 경우 "08", "09"일때 0으로 잘못 변경되므로 연산을 이용함.
		var mm = (s_date[1]*10)/10;
		var chk_day;
		var result;

		if ( date != "" )		// 입력값이 존재할때만 검사함
		{
			if ( (date.length >= 6) && (date.length <= 7) )		// [길이] 2001-1 ~ 2001-12
			{
				if ( s_date.length == 2 )		// [형식] xxxx-xx
				{
					if ( (yyyy >= 1899) && (yyyy <= 2200) )		// [년도] 1899년 ~ 2200년
					{
						if ( (mm >= 1) && (mm <= 12) )		// [월] 1월 ~ 12월
						{
							result = true;
						}
					}
				}
			}
			if (result != true)
			{
				alert(msg + "의 날짜형식이 잘못되었거나 올바른 날짜가 아닙니다.\n\n[2001-01]형식으로 입력하여 주십시오.");
				dateObject.focus();
				dateObject.select();
				return(false);
			}
		}
	}

	/* ex
			// 날짜여부 검사[2001-01]
			bCheck = form_chk_date_ym(form.c_buydate, "차량등록일");
			if ( bCheck == false ) return;
	*/



// 날짜여부 검사 (dateObject = document.form[0].date1)(msg = 객체명)
	function form_chk_datetime(dateObject, msg)
	{
		var date = dateObject.value;
		var s_datetime = date.split(" ");

		var s_date = s_datetime[0].split("-");
		var yyyy = (s_date[0]*10)/10;		// parseInt()의 경우 "08", "09"일때 0으로 잘못 변경되므로 연산을 이용함.
		var mm = (s_date[1]*10)/10;
		var dd = (s_date[2]*10)/10;

		var chk_day;
		var result;

		if ( date != "" )		// 입력값이 존재할때만 검사함
		{
			// date check
				if ( (s_datetime[0].length >= 8) && (s_datetime[0].length <= 10) )		// [길이] 2001-1-1 ~ 2001-12-12
				{
					if ( s_date.length == 3 )		// [형식] xxxx-xx-xx
					{
						if ( (yyyy >= 1899) && (yyyy <= 2200) )		// [년도] 1899년 ~ 2200년
						{
							if ( (mm >= 1) && (mm <= 12) )		// [월] 1월 ~ 12월
							{
								switch (mm) {		// [달별날수] 1월 - 31, 4월 - 30 ...
									case 2:
										chk_day = (!(yyyy % 4) && (yyyy % 100) || !(yyyy % 400)) ? 29 : 28;		// 윤년구분
										break;
									case 4: case 6: case 9: case 11:
										chk_day = 30;
										break;
									default :
										chk_day = 31;
										break;
								}
								//alert(chk_day + " / " + dd + " / " + s_date[2]);
								if ( (dd >= 1) && (dd <= chk_day) )			// [일] 1일 ~ 달별날수
								{
									result = true;
								}
							}
						}
					}
				}

			// time check
				if (s_datetime[1])
				{
					var s_time = s_datetime[1].split(":");
					var hh = (s_time[0]*10)/10;
					var ii = (s_time[1]*10)/10;
					var ss = (s_time[2]*10)/10;

					//alert(hh + ":" + ii + ":" + ss);

					if ( ((hh >= 0)&&(hh <= 23)) && ((ii != "")||((ii >= 0)&&(ii <= 59))) && ((ss != "")||((ss >= 0)&&(ss <= 59))) )
					{
						result = true;
					}else {
						result = false;
					}

				}

			if (result != true)
			{
				alert(msg + "의 날짜형식이 잘못되었거나 올바른 날짜가 아닙니다.\n\n[2001-01-01 08:30:00]형식으로 입력하여 주십시오.");
				dateObject.focus();
				dateObject.select();
				return(false);
			}
		}
	}


// 날짜 기간 검사 (dateObject1 = document.form[0].date1)(objName = 화면상에 표시될 객체이름)
	function form_compare_date(dateObject1, dateObject2, objName)
	{

		function form_getTime(value)
		{
			var d;	// Date Object
			var sd;		// Split Date
			sd= value.split("-");
			d = new Date(sd[0], sd[1], sd[2]);
			return(d.getTime());		// getTime() - returns a numeric value
		}

		var d1;		// First Compare Date
		var d2;		// Second Compare Date

		d1 = form_getTime(dateObject1.value);
		d2 = form_getTime(dateObject2.value);
		if (d1 > d2)
		{
			alert( objName + "이 잘못되었습니다.\n\n첫번째 날짜는 두번째날짜보다 빨라야 합니다." );
			dateObject1.focus();
			dateObject1.select();
			return(false);
		}
	}

	/* ex
			// 날짜 기간 검사
			bCheck = form_compare_date(form.c_hb_begin, form.c_hb_end, "할부기간");
			if ( bCheck == false ) return;
	*/



function trim(str)
{
	var retStr="" ;
	if (typeof(str) == "undefined") 
	{
		retStr = "";
	} else 
	{ 
		if (str == null) 
		{ 
			retStr = "";
		} else 
		{ 
			retStr= str.replace( /^\s*/, "" ).replace( /\s*$/, "" );  
		}
	}
	return retStr;
} 

// Change Div display
function changeDiv(IObject)
{
	var ObjStyle;

	if (IObject.style.display != "none")
	{
		ObjStyle = "none";
	}else{
		ObjStyle = "";
	}

	IObject.style.display = ObjStyle;
}


// [2005-05-19] TextArea 의 문자열길이를 기준으로 4줄까지 자동확장.
/*
	ex) 
		<textarea name=mf_to style="WIDTH:100%" rows=1 onFocus="JavaScript:rowsUpOnFocus(this, 2);" onKeyDown="if (event.keyCode==13) { return false; }; rowsUp(this, 40, 10);">
*/
function rowsUp(obj, word_cnt, max_rows)
{
	if (obj.value.length > 0)
	{
		var rows = Math.floor(obj.value.length / word_cnt) + 1;
		if (rows <= max_rows)
		{
			if (rows > obj.rows)
			{
				obj.rows = rows;
			}
		} else
		{
			obj.rows = max_rows;
		}
	}
}

function rowsUpOnFocus(obj, rows)
{
	if (obj.rows < rows)
	{
		obj.rows = rows;
	}
}


/*
	[2005-05-20]폼에서 여러개의 이메일주소 검사.
*/
function form_chk_emails(obj, objName)
{
	var chk_emails;
	chk_emails = obj.value.split(",");
	for(i = 0 ; i < chk_emails.length ; i++)
	{
		chk_emails[i] = trim(chk_emails[i]);
		if((chk_emails[i] != "")&&(!isEmail(chk_emails[i])))
		{
			alert(objName + "에서 잘못된 메일주소가 있습니다.\n\n=>" + chk_emails[i]);
			obj.focus();
			return(false);
		}
	}
}

function form_chk_emails_confirm(obj, objName)
{
	// [2009-08-07] 이름에 콤마(,)가 들어간 경우의 예외처리
	var objValue = obj.value.replace(/(\")+[^\"]+(\")+/g, '""');

	var chk_emails;
	chk_emails = objValue.split(",");
	for(i = 0 ; i < chk_emails.length ; i++)
	{
		chk_emails[i] = trim(chk_emails[i]);
		if((chk_emails[i] != "")&&(!isEmail(chk_emails[i])))
		{
			if (confirm(objName + "에서 잘못된 메일주소가 있습니다.\n\n수정하시겠습니까?\n\n=> " + chk_emails[i] + ""))
			{
				obj.focus();
				return(false);
			}
		}
	}
}


/*
	[2006-03-09] 도메인 주소 검사
*/
function form_chk_domain(obj, objName)
{
	var result;
	var msg;

	result = trim(obj.value);
	if (result != "")
	{
		// ^[a-zA-Z0-9\.-]+$
		var re = new RegExp("^[a-zA-Z0-9\\-\\.\\:]+$");
		if (!re.test(result))
		{
			alert(objName + "가(이) 잘못되었습니다.");
			obj.focus();
			if (obj.type == "text") obj.select();
			return(false);
		}
	}
}
